/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.Iterator;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientTickHandler;
import team.creative.ambientsounds.env.AmbientEnvironment;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public class BiomeEnvironment
implements Iterable<Pair<BiomeArea, BiomeStats>> {
    private final PairList<BiomeArea, BiomeStats> biomes = new PairList();

    public BiomeEnvironment() {
    }

    public BiomeEnvironment(AmbientEngine engine, class_1657 player, class_1937 level, double volume) {
        if (volume > 0.0) {
            class_2338 center = new class_2338(player.method_5836(CreativeCoreClient.getFrameTime()));
            class_2338.class_2339 pos = new class_2338.class_2339();
            for (int x2 = -engine.biomeScanCount; x2 <= engine.biomeScanCount; ++x2) {
                for (int z = -engine.biomeScanCount; z <= engine.biomeScanCount; ++z) {
                    pos.method_10103(center.method_10263() + x2 * engine.biomeScanDistance, center.method_10264(), center.method_10260() + z * engine.biomeScanDistance);
                    class_6880 holder = level.method_23753((class_2338)pos);
                    float biomeVolume = (float)((1.0 - Math.sqrt(center.method_10262((class_2382)pos)) / (double)(engine.biomeScanCount * engine.biomeScanDistance * 2)) * volume);
                    BiomeArea area = new BiomeArea(level, (class_6880<class_1959>)holder, (class_2338)pos);
                    Pair before = this.biomes.getPair((Object)area);
                    if (before == null) {
                        this.biomes.add((Object)area, (Object)new BiomeStats(biomeVolume));
                        continue;
                    }
                    ((BiomeStats)before.value).volume = Math.max(((BiomeStats)before.value).volume, (double)biomeVolume);
                }
            }
            this.biomes.sort((x, y) -> ((BiomeStats)y.value).compareTo((BiomeStats)x.value));
        }
    }

    @Override
    public Iterator<Pair<BiomeArea, BiomeStats>> iterator() {
        return this.biomes.iterator();
    }

    public static class BiomeArea {
        public final class_6880<class_1959> biome;
        public final class_2960 location;
        public final class_2338 pos;

        public BiomeArea(class_1937 level, class_6880<class_1959> biome, class_2338 pos) {
            this.biome = biome;
            this.location = level.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)biome.comp_349()));
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                if (!this.location.method_12832().matches(".*" + name.replace("*", ".*") + ".*")) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome.equals(this.biome);
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }

    public static class BiomeStats
    implements Comparable<BiomeStats> {
        private double volume;

        public BiomeStats(double volume) {
            this.volume = volume;
        }

        public double volume(AmbientEnvironment env, String type) {
            return this.volume * env.biomeTypeVolumes.getOrDefault(type, 1.0);
        }

        @Override
        public int compareTo(BiomeStats o) {
            return Double.compare(this.volume, o.volume);
        }

        public String toString() {
            return AmbientTickHandler.df.format(this.volume);
        }
    }
}

